;==================================================================================================
; ISN Debug Console
;==================================================================================================

#include "..\Forms\ISN_Debug_Console.isf" ;Debug Console



Func _Resize_Debug_Console()
	$ConsoleGUI_Size = _WinGetClientSize($console_GUI)
	If IsArray($ConsoleGUI_Size) Then
		GUICtrlSetPos($console_commandlabel, 0, $ConsoleGUI_Size[1] - 20, 72, 20)
		GUICtrlSetPos($console_commandinput, 72, $ConsoleGUI_Size[1] - 20, $ConsoleGUI_Size[0] - 72, 20)
		ControlMove($console_GUI, "", $console_chatbox, 0, 40 * $DPI, $ConsoleGUI_Size[0], $ConsoleGUI_Size[1] - (40 * $DPI) - 20)
	EndIf
EndFunc   ;==>_Resize_Debug_Console




Func _Write_ISN_Debug_Console($String = "", $level = 2, $break = 1, $notime = 0, $notitle = 0, $Category = "")
	If $SHOW_DEBUG_CONSOLE <> "true" Then Return

	If $level = 1 And GUICtrlRead($debug_console_info_checkbox) = $GUI_UNCHECKED Then Return
	If $level = 2 And GUICtrlRead($debug_console_warning_checkbox) = $GUI_UNCHECKED Then Return
	If $level = 3 And GUICtrlRead($debug_console_critical_checkbox) = $GUI_UNCHECKED Then Return
	If $Category = "" And GUICtrlRead($debug_console_ISNstuff_checkbox) = $GUI_UNCHECKED Then Return
	If $Category = $ISN_Debug_Console_Category_Plugin And GUICtrlRead($debug_console_plugin_checkbox) = $GUI_UNCHECKED Then Return
	If $Category = $ISN_Debug_Console_Category_Hotkey And GUICtrlRead($debug_console_hotkey_checkbox) = $GUI_UNCHECKED Then Return

	$String = StringReplace($String, "\", "\\")



	If $break = 1 Then
		$br = @CRLF
	Else
		$br = ""
	EndIf

	If $notime = 1 Then
		$time = ""
	Else
		$time = @HOUR & ":" & @MIN & ":" & @SEC & "  "
	EndIf


	If $notitle = 1 Then
		$title = ""
	Else
		$title = ""
		If $level = 1 Then $title = "<INFO>      "
		If $level = 2 Then $title = "<WARNING>   "
		If $level = 3 Then $title = "<CRITICAL>  "
	EndIf

	$str = ""
	If $level = 0 Then
		$str = "[c=#FFFFFF]" & $String & "[/c] " & $br
		$str = StringReplace($str, $Plugin_System_Delimiter, "[/c][c=#00CCFF] ║ [/c][c=#FFFFFF]")
	EndIf

	If $level = 1 Then
		$str = "[c=#00FF00]" & $title & $time & $String & "[/c] " & $br
		$str = StringReplace($str, $Plugin_System_Delimiter, "[/c][c=#00CCFF] ║ [/c][c=#00FF00]")
	EndIf

	If $level = 2 Then
		$str = "[c=#FCFF00]" & $title & $time & $String & "[/c] " & $br
		$str = StringReplace($str, $Plugin_System_Delimiter, "[/c][c=#00CCFF] ║ [/c][c=#FCFF00]")
	EndIf

	If $level = 3 Then
		$str = "[c=#FF0000]" & $title & $time & $String & "[/c] " & $br
		$str = StringReplace($str, $Plugin_System_Delimiter, "[/c][c=#00CCFF] ║ [/c][c=#FF0000]")
	EndIf

	_GUICtrlRichEdit_SetFont($console_chatbox, Floor(11 * Floor($DPI)), "Consolas")
	_ChatBoxAdd($console_chatbox, $str)
	If $ISNDebugConsole_SpecialLogs <> 0 OR GUICtrlRead($debug_console_hotkey_checkbox) = $GUI_CHECKED Then
		AdlibRegister("_ISN_DebugConsole_ScrollDownAdlib", 100)
	Else
		If GUICtrlRead($debug_console_autoscroll_checkbox) = $GUI_CHECKED Then _SendMessage($console_chatbox, $WM_VSCROLL, $SB_BOTTOM, 0)
	EndIf
EndFunc   ;==>_Write_ISN_Debug_Console

Func _ISN_DebugConsole_ScrollDownAdlib()
	AdlibUnRegister("_ISN_DebugConsole_ScrollDownAdlib")
	If GUICtrlRead($debug_console_autoscroll_checkbox) = $GUI_CHECKED Then _SendMessage($console_chatbox, $WM_VSCROLL, $SB_BOTTOM, 0)
EndFunc   ;==>_ISN_DebugConsole_ScrollDownAdlib


Func _ISN_DebugConsole_ArrowUpEvent()
   Local $TextToSelect
	if _GUICtrlComboBox_GetLBText($console_commandinput, $ISNDebugConsole_ComboIndex, $TextToSelect) = -1 then return
	GUICtrlSetData($console_commandinput,$TextToSelect)
	If $ISNDebugConsole_ComboIndex+1 < _GUICtrlComboBox_GetCount($console_commandinput) then $ISNDebugConsole_ComboIndex = $ISNDebugConsole_ComboIndex+1
 EndFunc

Func _ISN_DebugConsole_ArrowDownEvent()
   Local $TextToSelect
	if _GUICtrlComboBox_GetLBText($console_commandinput, $ISNDebugConsole_ComboIndex-1, $TextToSelect) = -1 then return
	GUICtrlSetData($console_commandinput,$TextToSelect)
	If $ISNDebugConsole_ComboIndex-1 > 0 then $ISNDebugConsole_ComboIndex = $ISNDebugConsole_ComboIndex-1
 EndFunc

Func _Send_consolCommand()
	$ISNDebugConsole_ComboIndex = 0
	$to_exec = GUICtrlRead($console_commandinput)
	If $to_exec = "" Then Return

	_GUICtrlComboBox_InsertString($console_commandinput, GUICtrlRead($console_commandinput), 0)
	_GUICtrlComboBox_SetEditText($console_commandinput, "")

	If StringInStr($to_exec, "print ") Or StringInStr($to_exec, "pt ") Then
		$value = $to_exec
		$value = StringReplace($value, "print ", "")
		$value = StringReplace($value, "pt ", "")
		_Write_ISN_Debug_Console("Value of " & $value & ": " & StringReplace(Execute($value), "\", "\\"), 0)
		Return
	EndIf


	If $to_exec = "clip" Or $to_exec = "cp" Then
		ClipPut(_GUICtrlRichEdit_GetText($console_chatbox, True))
		_Write_ISN_Debug_Console("Content copied to the clipboard!", 0)
		Return
	EndIf

	If $to_exec = "restart" Or $to_exec = "r" Then
		_Restart_ISN_AutoIt_Studio()
		Return
	EndIf

	If $to_exec = "clear" Or $to_exec = "cls" Then
		_ChatBoxClear($console_chatbox)
		Return
	EndIf

	If $to_exec = "listthreads" Or $to_exec = "lt" Then
		_Debug_List_ISN_Threads()
		Return
	EndIf


	If $to_exec = "exit" Or $to_exec = "q" Then
		$AskExit = "false"
		AdlibRegister("_exit", 1)
		Return
	EndIf

	If StringInStr($to_exec, "tell scripttree ") Or StringInStr($to_exec, "t scripttree ") Then
		$value = $to_exec
		$value = StringReplace($value, "tell scripttree ", "")
		$value = StringReplace($value, "t scripttree ", "")
		$result = _ISN_Execute_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], $value)
		_Write_ISN_Debug_Console("Result of '" & $value & "': " & $result, 0)
		Return
	EndIf

	If $to_exec = "enablespeciallog" Or $to_exec = "esl" Then
		_Write_ISN_Debug_Console("Current special logs value: " & $ISNDebugConsole_SpecialLogs, 0)
		Return
	EndIf


	If StringInStr($to_exec, "enablespeciallog ") Or StringInStr($to_exec, "esl ") Then
		$value = $to_exec
		$value = StringReplace($value, "enablespeciallog ", "")
		$value = StringReplace($value, "esl ", "")
		Switch Number($value)

			Case 1 ;TVExplorer Logs
				If Not BitAND($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_TVExplorer) Then
					$ISNDebugConsole_SpecialLogs = BitOR($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_TVExplorer)
					_Write_ISN_Debug_Console("Special Logs for TVExplorer UDF enabled!", 0)
				Else
					$ISNDebugConsole_SpecialLogs = BitXOR($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_TVExplorer)
					_Write_ISN_Debug_Console("Special Logs for TVExplorer UDF disabled!", 0)
				EndIf

;~ 			Case 2 ;HotkeyUDF Logs
;~ 				If Not BitAND($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_HotkeyUDF) Then
;~ 					$ISNDebugConsole_SpecialLogs = BitOR($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_HotkeyUDF)
;~ 					_Write_ISN_Debug_Console("Special Logs for HotKey UDF enabled!", 0)
;~ 				Else
;~ 					$ISNDebugConsole_SpecialLogs = BitXOR($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_HotkeyUDF)
;~ 					_Write_ISN_Debug_Console("Special Logs for HotKey UDF disabled!", 0)
;~ 				EndIf

			Case 3 ;WM_NOTIFY
				If Not BitAND($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_WMNOTIFY) Then
					$ISNDebugConsole_SpecialLogs = BitOR($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_WMNOTIFY)
					_Write_ISN_Debug_Console("Special Logs for WM_NOTIFY enabled!", 0)
				Else
					$ISNDebugConsole_SpecialLogs = BitXOR($ISNDebugConsole_SpecialLogs, $ISNDebugConsole_SpecialLogs_WMNOTIFY)
					_Write_ISN_Debug_Console("Special Logs for WM_NOTIFY disabled!", 0)
				EndIf

		EndSwitch
		Return
	EndIf

	If $to_exec = "localupgrade" Or $to_exec = "lu" Then
		_install_local_upgrade_file()
		Return
	EndIf

	If $to_exec = "help" Or $to_exec = "?" Then
		$str = "Available commands:" & @CRLF & _
				"---------------------" & @CRLF & @CRLF & _
				"clear [cls]" & @TAB & @TAB & @TAB & @TAB & @TAB & "Clear this console" & @CRLF & _
				"clip [cp]" & @TAB & @TAB & @TAB & @TAB & @TAB & "Copy the content of this console in the clipboard" & @CRLF & _
				"help [?]" & @TAB & @TAB & @TAB & @TAB & @TAB & "This Text" & @CRLF & _
				"restart [r]" & @TAB & @TAB & @TAB & @TAB & @TAB & "Restarts the ISN AutoIt Studio" & @CRLF & _
				"localupgrade [lu]" & @TAB & @TAB & @TAB & @TAB & "Forces the ISN AutoIt Studio Updater to install a local updatefile" & @CRLF & _
				"listthreads [lt]" & @TAB & @TAB & @TAB & @TAB & "Displays a list with all runing ISN Helper threads (PID and handle)" & @CRLF & _
				"print [pt] VALUE OR FUNCTION" & @TAB & @TAB & "Prints the content of a $ value or the result of a function" & @CRLF & _
				"tell [t] THREAD STRING" & @TAB & @TAB & @TAB & "Sends AutoIt Code to a thread process" & @CRLF & _
				"enablespeciallog [esl] NUMBER" & @TAB & @TAB & "Enables some special log output in this console" & @CRLF & _
				"exit [q]" & @TAB & @TAB & @TAB & @TAB & @TAB & "Shutdown (Exit) the ISN AutoIt Studio" & @CRLF & _
				"---------------------" & @CRLF & _
				"NOTE: The value in brackets is the short version of the command." & @CRLF & @CRLF
		_Write_ISN_Debug_Console($str, 0)
		Return
	EndIf

	$result = Execute($to_exec)
	If @error Then
		_Write_ISN_Debug_Console("Command '" & $to_exec & "' not found!", 3, 1, 1, 1)
	Else
		_Write_ISN_Debug_Console("Result of '" & $to_exec & "': " & $result, 0)
	EndIf

EndFunc   ;==>_Send_consolCommand

Func _Debug_List_ISN_Threads()
	$str = "Currently active ISN Threads:" & @CRLF & _
			"------------------------------------------" & @CRLF & _
			"Thread" & @TAB & @TAB & "PID" & @TAB & @TAB & "Handle" & @CRLF & _
			"------------------------------------------" & @CRLF
	$str = $str & _ArrayToString($ISN_Helper_Threads, @TAB & @TAB) & @CRLF & _
			"------------------------------------------" & @CRLF & @CRLF
	_Write_ISN_Debug_Console($str, 0)
EndFunc   ;==>_Debug_List_ISN_Threads

Func _Restart_ISN_AutoIt_Studio()
	$AskExit = "false"
	$ISN_Restart_initiated = 1
	AdlibRegister("_exit", 1)
EndFunc   ;==>_Restart_ISN_AutoIt_Studio

Func _Shutdown_ISN_AutoIt_Studio()
	$AskExit = "false"
	AdlibRegister("_exit", 1)
EndFunc   ;==>_Shutdown_ISN_AutoIt_Studio

Func _debug_console_set_on_top()
	If GUICtrlRead($debug_console_ontopmode_checkbox) = $GUI_CHECKED Then
		WinSetOnTop($console_GUI, "", 1)
	Else
		WinSetOnTop($console_GUI, "", 0)
	EndIf
EndFunc   ;==>_debug_console_set_on_top

Func _RestartISNAsAdmin()
	Local $StudioExe = ""

	If $Offenes_Projekt = "" then		
			;Restart ISN without any project
			If @Compiled Then
				$Helper_PID = Run('"' & $IntegratedAutoIt3_exe & '" "' & @ScriptDir & "\Data\ISN_Adme.a3x" & '" ' & '"/runasadmin %DoubleQuote%' & @ScriptDir & "\AutoIt_Studio.exe" & "%DoubleQuote%" & '"', @ScriptDir)
			Else
				$StudioExe = "ShellExecute('%DoubleQuote%" & $autoitexe & "%DoubleQuote%','%DoubleQuote%" & @ScriptDir & '\' & @ScriptName & "%DoubleQuote%')"
				$Helper_PID = Run('"' & $IntegratedAutoIt3_exe & '" "' & @ScriptDir & "\Data\ISN_Adme.a3x" & '" ' & '"/execute ' & $StudioExe & '"', @ScriptDir)
			EndIf		
		
		Else
			;Restart ISN and reopen the new project		
			If @Compiled Then
				$Helper_PID = Run('"' & $IntegratedAutoIt3_exe & '" "' & @ScriptDir & "\Data\ISN_Adme.a3x" & '" ' & '"/runasadmin %DoubleQuote%' & @ScriptDir & "\AutoIt_Studio.exe" & "%DoubleQuote% %DoubleQuote%" & $Pfad_zur_Project_ISN & "%DoubleQuote%" & '"', @ScriptDir)
			Else
				$StudioExe = "ShellExecute('%DoubleQuote%" & $autoitexe & "%DoubleQuote%','%DoubleQuote%" & @ScriptDir & '\' & @ScriptName & "%DoubleQuote%' " & "& ' ' &" & " '%DoubleQuote%" & $Pfad_zur_Project_ISN & "%DoubleQuote%')"
				$Helper_PID = Run('"' & $IntegratedAutoIt3_exe & '" "' & @ScriptDir & "\Data\ISN_Adme.a3x" & '" ' & '"/execute ' & $StudioExe & '"', @ScriptDir)
			EndIf				
	Endif

	If $Helper_PID <> 0 Then
		;Success, shutdown current ISN session
		_Close_Project("false")
		$AskExit = "false"
		AdlibRegister("_exit", 1)
		return true
	Else
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1488), 0, $studiofenster)
		return false
	EndIf
EndFunc   ;==>_RestartISNAsAdmin
